<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vessel extends Model 
{

    protected $table = 'vessels';
    public $timestamps = true;
    protected $fillable = array('name', 'desc', 'vessel_number', 'width', 'vessel_model', 'length', 'speed', 'image', 'grouping', 'max_passengers', 'default_route');

    public function createdBy()
    {
        return $this->belongsTo('App\User', 'created_by');
    }

    public function vesselModel()
    {
        return $this->belongsTo('App\Models\VesselModel', 'vessel_model');
    }

    public function lines()
    {
        return $this->hasMany('App\Models\Lien', 'vessel_id');
    }

    public function vesselCabinsCounts()
    {
        return $this->hasMany('App\Models\VesselCabinsCount', 'vessel_id');
    }

}